#!/usr/bin/env python 
"""List all the fonts in the current document.

This extension is not parsing the XML since I saw no benefits to
do that at the time, feel free to improve.

"""

__version__ = "2010-04-21"
__author__ = "Bertrand Janin <tamentis@neopulsar.org>"
__license__ = "Public Domain"

import sys
import re

html_codes = (
    ('&', '&amp;'),
    ('<', '&lt;'),
    ('>', '&gt;'),
    ('"', '&quot;'),
    ("'", '&#39;'),
)

try:
    data = open(sys.argv[1], "rb").read()
except:
    sys.stderr.write("Unable to read your Inkscape document.")

for char, entity in html_codes:
    data = data.replace(entity, char)

fonts = re.findall(r"font-family:\s*([^;\"]+);", data)

if len(fonts) == 0:
    sys.stderr.write("No fonts found.")
    sys.exit(0)
 
sys.stderr.write("Fonts in this documents: ")
sys.stderr.write(", ".join(set(fonts)))

